### Definition

- **Intrusion Policies**: Sets of configurations for intrusion detection and prevention.
- **Purpose**: Inspect traffic for security violations; block or alter malicious traffic.
- **Invocation**: Activated by Access Control Policy (ACP).

### Key Components

- **Intrusion Rules**: Core elements of intrusion policies.
    - Enabled rules generate intrusion events and may block traffic.
    - Base policies provided by Cisco Talos set initial configurations.

## Snort Rules

### Description

- **Snort**: Free, open-source network intrusion detection system.
- **Integration**: Cisco Secure Firewall Threat Defense is based on Snort.
- **Rule Structure**: Contains rule header and rule body.

### Rule Header

- Action or type
- Protocol
- Source and destination IP addresses and ports
- Direction indicators for traffic flow

### Rule Body

- Event message
- Keywords and parameters
- Payload patterns
- Packet inspection specification
- Snort ID (SID)

## Custom Intrusion Policies

### Creation

- Name the policy and select a base policy.
- Tune detection by enabling/disabling rules or adding custom rules.

### Drop Behavior

- **Drop When Inline**: Determines handling of drop rules.
    - Drop malicious packets in inline deployments.
    - Passive deployments do not affect traffic flow.

### Rule States

- Generate Events
- Drop and Generate Events
- Disable

## Base Intrusion Policies

### Overview

- System-provided policies managed by Talos.
- Regular updates from Talos for rule modifications and additions.

### Types

- **Security Over Connectivity**: Prioritizes network security; may impact performance.
- **Connectivity Over Security**: Prioritizes uninterrupted operations; fewer rules enabled.
- **Balanced Security and Connectivity**: Recommended for most networks; balances detection and performance.

## Cisco Recommendations

### Functionality

- Automates rule creation and management.
- Tailors intrusion policy to network vulnerabilities.

### Configuration Options

- Redefine monitored hosts.
- Influence recommended rules.
- Generate recommendations to disable rules.

### Rule State Adjustments

- Recommendations based on network assets.
- Default settings for low/medium overhead rules.

## Assigning IPS Policy in Access Control Policy

### Process

- Assign intrusion policies to ACP rules or default actions.
- Intrusion policies can be system-provided or user-created.

### Application

- Intrusion policies applied within ACPs tailored to network priorities.

## IPS Events

### Description

- Generated by threat defense upon detecting intrusions.
- Includes date, time, exploit type, source, and target information.

### Access

- View IPS events under Analysis > Intrusions > Events.